function [loss_dist, num_available] = port_loss_dist3(dates, T, portfolio, index_members, y0, ajd_common_factor, N)
% --------------------------------------------------------------------------------------------------
% Calculate the (unconditional) portfolio loss distribution for a portfolio of credit default swaps
% for various time horizons.
% --------------------------------------------------------------------------------------------------
% dates             ... dates for which to compute future portfolio loss distribution
% T                 ... horizons for which to compute future portfolio loss distribution
% portfolio         ... portfolio of credit default swaps
% index_members     ... indicator matrix, i-th row representing members of index for i-th date
% y0                ... initial intensity of common factor
% ajd_common_factor ... AJD dynamics of the common factor
% N                 ... number of points for numerical integration of transform
% --------------------------------------------------------------------------------------------------
% sample call: port_loss_dist3(cdx_test.dates{1}, [1 5; 2 4], cdx_test.portfolio, cdx_test.index_members, [0.01; 0.01], ajd_dynamics, 1000)
%              port_loss_dist3(cdx_test.dates{1}, [0:0.25:5; 0:0.25:5], cdx_test.portfolio, cdx_test.index_members, [0.01; 0.01], ajd_dynamics, 1000)
% --------------------------------------------------------------------------------------------------

% Extract parameter time series of common factor
[k, theta, sigma, L, mu] = generate_parameter_time_series(ajd_common_factor, dates);

% Get idiosyncratic survival probabilities
[p_surv_idio, ai, available_data] = get_p_surv_idio3(dates, T, portfolio, y0, ajd_common_factor);

% Pre-allocate memory
num_dates = length(dates);
num_horizons = size(T,2);
loss_dist = zeros(num_dates, num_horizons, max(sum(available_data,2))+1);
num_available = zeros(num_dates, 1);

% For each date, calculate unconditional portfolio loss distribution for each horizon
for j=1:num_dates
    % Calculate density of common factor
    %[density, dz] = density_integrated_ajd2_adaptive(y0(j), k(j), theta(j), sigma(j), L(j), mu(j), T(j,:), N);
    %[density, dz] = density_integrated_ajd3(y0(j), k(j), theta(j), sigma(j), L(j), mu(j), T(j,:), N, 4);
    
    
    % Integrate over conditional portfolio loss distribution to get unconditional distribution          
    for i=1:num_horizons
        % Calculate density of common factor
        [density, dz] = density_integrated_ajd5(y0(j), k(j), theta(j), sigma(j), L(j), mu(j), T(j,i), N, 4);        
        
        % Determine companies that are (i) index members and (ii) have date available        
        used_firms = (index_members(j,:) > 0) & (available_data(j,:) > 0);
        num_available(j) = sum(used_firms);

        % Calculate portfolio loss distribution for given date and horizon
        if (0)  % Old version
            % Make density spare to save time in recursion - use only 10000 of the point
            density_sparse = sparse_density(reshape(density(i,:), [1, N]), dz, 5000, 0);
            loss_dist(j,i,1:(num_available(j)+1)) = horizon_loss_dist_c4(ai(j,used_firms), density_sparse);
        elseif (0)    % New version bases on Simpsons's quadrature with support points bases on quantiles
            [points, weights, weights_middle] = sparse_density2(reshape(density, [1, N]), dz, 2000);
            %plot(points, weights);
            loss_dist(j,i,1:(num_available(j)+1)) = uncond_loss_dist2(ai(j,used_firms), reshape(p_surv_idio(j,i,used_firms), ...
                                                                      [1, num_available(j)]), points', weights', weights_middle');
        else          % Newest version based on Gauss-Legendre quadrature
            %test = uncond_loss_dist2(ai(j,used_firms), reshape(p_surv_idio(j,i,used_firms), [1, num_available(j)]), points', weights', weights_middle'); 
            [points, weights, weights_middle] = sparse_density3(density, dz, 250, 5);
            loss_dist(j,i,1:(num_available(j)+1)) = uncond_loss_dist3(ai(j,used_firms), reshape(p_surv_idio(j,i,used_firms), ...
                                                                      [1, num_available(j)]), points, weights_middle);
        end
    end

end
loss_dist = loss_dist(:, :, 1:(max(num_available)+1));
%disp(mean(squeeze(p_surv_idio(2,end,:))));
%test=squeeze(loss_dist(2,end,:)); disp(test(1:10)');
%disp(loss_dist);
